using System;
using System.Windows;

// Listing 4-1 (część 1). Klasy reprezentujące strażaka oraz wóz straży pożarnej
class Firefighter
{
    public string Name { get; set; }
    public void ExtinguishFire()
    {
        Console.WriteLine("{0} gasi pożar!", Name);
    }
    public void Drive(Firetruck truckToDrive, Point coordinates)
    {
        if (truckToDrive.Driver != this)
        {
            // Nie można jechać wozem straży pożarnej, jeśli 
            // nie ma kto nim kierować,
            // jednak takie zakańczanie metody bez zgłaszania 
            // informacji o problemie jest BARDZO ZŁE.
            // Tym, czego nam potrzeba, jest jakiś strukturalny 
            // sposób przekazywania klientom używającym naszych klas
            // informacji o problemach, które w nich zaistniały.
            // Wrócimy do tego zagadnienia w rozdziale 6.
            return;
        }
        truckToDrive.Drive(coordinates);
    }
}